/****************************************************************************\
*  This source is freeware, compiled under 32-Bit Djgpp for MS-Dos.          *
*  If anyone uses this source, at least be kind enough to include YOUR sorce *
*  of this source which is me, John C [ Bongo`]. That's all!                 *
* If you have any questions or need help, email me at jcbk101@juno.com       *
\****************************************************************************/
#include <conio.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <pc.h>
#include <fcntl.h>
#include <io.h>
#include <Tiles.h>

#include <dos.h>
#include <string.h>
#include <dpmi.h>
#include <go32.h>
#include <sys\nearptr.h>

#define SCRN  320 * 200


typedef unsigned char byte;
typedef unsigned int  word;
typedef unsigned long dwrd;
typedef   signed long lng2;


/* DECLARATIONS */

 byte *VGA;                     // Video memory pointer
 byte *MenuBar;                 // Menu bar
 byte *rombuf[2];

 byte page1[64000];             // video page buffer
 byte buffr[64000];             // draw to buffer first, than to the screen
 byte *imprt;                   // BMP display screen
 byte charb[4096];              // temp storage for Char box pixel data

 byte copy[0x2000];             // buffer for the copied BMP image
 byte newp[1024];               // palette data
 byte data[320];                // buffer to hold BMP data when reading
 byte Text[256];                /* Used for Tile Data */
 byte men1[9][17];

 const char *modename[6]={ //Tile modes
  "1 - Bit Plane  ",
  "NES Tile Mode  ",
  "Game Boy Mode  ",
  "Snes 4bp Mode  ",
  "8 - Bit Plane  ",
  "Raw Byte Mode  "
 };

unsigned int buttons[96]={
 0xFFFE,0x8001,0x8181,0x87E1,   //plus up
 0x87E1,0x8181,0x8001,0x7FFF,
 0xFFFF,0x8000,0x8000,0x8000,
 0x8000,0x8000,0x8000,0x8000,

 0xFFFE,0x8001,0x80C1,0x83F1,   //plus down
 0x83F1,0x80C1,0x8001,0x7FFF,
 0x0001,0x0001,0x0001,0x0001,
 0x0001,0x0001,0x0001,0xFFFF,

 0xFFFE,0x8001,0x8001,0x87E1,   //minus up
 0x87E1,0x8001,0x8001,0x7FFF,
 0xFFFF,0x8000,0x8000,0x8000,
 0x8000,0x8000,0x8000,0x8000,

 0xFFFE,0x8001,0x8001,0x83F1,   //minus down
 0x83F1,0x8001,0x8001,0x7FFF,
 0x0001,0x0001,0x0001,0x0001,
 0x0001,0x0001,0x0001,0xFFFF,

 0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0,
 0,0,0,0,0,0,0,0
};


 lng2 ofs[2]={0,0};  // file offsets for files
 lng2 plc=0;         // used to hold the addresses for mouse to rom position
 dwrd lof1[2]={0,0}; // length of each file
 dwrd ypos;          // varies
 dwrd tx;            // ""
 dwrd ty;            // ""

 word men2[9];       // menu item key values when selected
 word memy;          // varies
 word memx;          // ""
 word memd;          // ""
 word meme;          // ""

 word hicol[2]={0,0};// flag for more than 16 colors selection
 word n=0;     /* key Press */
 word key2=0;  /* key Press */

 word vprt;
 word dec;           // used to determine bits for tiles
 word a1;            // varies
 word b1;            // ""
 word a2;            // ""
 word b2;            // ""
 word xcrd;          // ""
 word ycrd;          // ""
 word val;           // ""
 word cx, dx;        // ""
 word cpos;

 FILE *fil[2]={0,0}; // file pointers
 FILE *tfil,*bfil;   // temp file pointer and bitmap file pointer

 byte col;           // col to determine pixel output
 byte cur = 1;       // ""
 byte x,y,a;         // ""

 byte fgc=127;       // foreground color
 byte brd=15;        // border color

 byte keyy;  /* key Press */
 word altk;          // Alt-Key variable

 byte curs;          // used to select which menu to use
 byte Max1=0;        // Maximum menu items per menu
 byte xy=0;          // use for menu GUI
 byte menx;          // varies
 byte meny;          // varies

 word num=0;
 char filnm[2][80]={"",""};  // buffers file the rom files
 char NOFile[80]={0};        // temp name to get input for file names
 char temp[80];              // used for text out and other stuff
 char k;                     // flag for key press routine
 char c;                     // holds byte for 1-bit plane data

 word bpp[2]={0,0};  /* Bit plane flag */
 char pln[2]={0,0};          // bit planes per file
 char pal[2]={1,1};          // flag for plane and color combo
 char cpal[2];               // flag for pal
 char newpal=0;              // flag for pal

 char pos[2]={0,0};          // used for NES and GB mode
 char bp4[2]={0,0};          // used for Snes 4bp and 8-Bitplane
 char act=1;
 char inc;                   // used for Draw tiles operations
 char rst;
 char wrt=0;
 char addy=0;
 char less=0;
 char wide=0;                // Dermines if 8x8 or 8x16 tile edit

 char MaxY=0;                // BMP stuff
 char MaxX=0;                // ""

/* Mouse values */
 char ml=0;                  //mouse left click
 char mr=0;                  //mouse right click
 char click=0;
 char mx=0;                  // mouse X cord relative to screen
 char my=0;                  // mouse Y cord relative to screen

 int  my2=0;                 // mouse Y in pixels
 int  mx2=0;                 // mouse X in pixels

 char mlc=0;                 // mouse color for left click
 char mrc=0;                 // mouse color for right click
/* Mouse values */

 int z, bp;   // All used for Drawing Tiles
 int sp, I;
 byte j;      // ""

 int hnd;     // file handle used to get length of file


/* BMP Header Structure */
 word  ftype;
 word  fsize;
 word  fofs;
 word  info;
 word  xsz;
 word  ysz;
 word  plns;
 word  bits;
 word plen;

/* Variables used for BMP functions */
 word crx=0;
 word cry=0;
 word bmy;
 word bmx;
 word bmd;
 word bme;

 byte b;
 byte g;
 byte r;

 char clr;
 char stats=0;
 char nomove=0;
/* BMP Header Structure */


/* SUBROUTINES */
void Window(int, int, int, int);
void strfrm(byte cnt, byte ch, byte stg[80]);
void pcopy(byte pg1, byte pg2);
void FileMenu();

void EditMenu();
void OptsMenu();
void HelpMenu();
void ChangeRomFile();

void InitMouse();
void ShowMouse();
void HideMouse();
void MouseStat();

void PopUpMenu();
void Status();
void Load_Menu(byte curs);
void Screen(byte mode);

void ShowMenu(byte xy, byte curx);
void DrawTiles();
word TestMousePos();
void PixScrFill(word x1, word x2, word y1, word y2, byte color, char border, char type);

void Shadow(word x1, word x2, word y1, word y2, byte color, char border);
void PerCent();
void Waiter();
void BitDraw(byte cl);

void TextOut(byte txt[80], byte txtclr, byte bckclr, byte x, byte y, char type);
void Vblank();
void ColorSet(int, int, int, int, char);

void TilePress();
void ClipPress();
void CharPress();
void ColorPress();

int ClickColor(int, int);
dwrd MessageBox(char msg[80], int, int, int,char);
void NewMouse();
void ButtonDraw(char, byte, byte,char);

void LoadSaveFiles(char, char);
void NewOpenClick();
void Box(word, word);
void ChangeCharSize();

void CommandLoad(int, char *argv[]);
void HelpScreen();
void NoCursor();
void ImportBmp();

void InfoLoad();
void SetPal();
void LoadPal();
void CopyPaste(char);

void DrawBmp();
void BMPOpen();
void LetItGo();
void SetMemPoint(int flag);
/* SUBROUTINES */


int main(argc, argv)
int argc;
char *argv[];
{

 if ((MenuBar = (byte *) malloc(8 * 320)) == NULL){
  printf("Not enough memory");
  exit(1);
 }

 if ((imprt = (byte *) malloc(65535)) == NULL){
  printf("Not Enough memory");
  exit(1);
 }

 clrscr();
 CommandLoad(argc, argv);


 if ((tfil = fopen("Readme.txt", "r+")) == NULL){
  clrscr();
  printf("Be sure to read the readme in this program or the file for\n\rprogram usage.");
  tfil = fopen("readme.txt","w+t");
  for (a1=0; a1 < 76; a1++){
	fprintf(tfil, "%s\n",hbuf[a1]);
  }
  while(!kbhit()){
  }
 }/* END IF */
 fclose(tfil);


 Screen(0x13);
 InitMouse();
 SetMemPoint(1);


 Vblank();
 PixScrFill(0, 320, 0, 200, fgc, brd,'p');     // Screen
 PixScrFill(143, 273, 7, 73, 0, brd,'p');      // ClipBoard
 PixScrFill(7, 137, 7, 169, 0, brd,'p');       // Tile Window

 PixScrFill(143,209+(wide<<6),103,169,0,brd,'p');   // Char Box
 PixScrFill(7, 137, 182, 193, 0, brd,'p');     // Hex Location
 PixScrFill(7, 137, 170, 181, 0, brd,'p');     // Tile Mode
 PixScrFill(230, 246, 186, 193, 0, brd,'p');   // Mouse Color
 ButtonDraw(0x0D,178,143,0);                   // Minus Button
 ButtonDraw(0x0C,178,160,0);                   // Plus Button


 PerCent();
 Status();
 ShowMouse();

 Vblank();
 DrawTiles();  // Draw the Tiles
 Status();     //Print status stuff to screen


/****************************************
;   Main KeyBoard And Mouse Functions   *
;   Are in this Particular Area.        *
;***************************************/
GetKey:
click=0;

 MouseStat();
 if(ml==1 || mr==1){
  goto MouseDown;
 }

 {// Test for ALT-Key
  __dpmi_regs r;

  r.h.ah = 2;
  __dpmi_int(0x16, &r);
  altk = r.x.ax;
 }


 if ((altk & 8) == 8){ /* Alt-Key tester */
   {
   __dpmi_regs r;
   r.h.ah = 1;
   __dpmi_int(0x16, &r);
   altk = (r.x.ax & 0xFF00);
   }

   if (altk == 0x2D00){
    key2 = 0xFF00;
    goto Response;
   }else if (altk == 0x2E00){
    key2 = 0x5500;
    goto Response;
   }/* END IF */
   goto GetKey;
  }/* END IF */
/* Alt-Key tester */


/* Main test for Key press */
 key2 = inportb(0x60);
 if (key2 & 0x80){
  goto GetKey;
 }else{
  key2=key2 << 8;
  goto Response;
 }
/* Main test for Key press */


MouseDown:
/* Mouse tester for Tile retrieval and others */
  if((ml == 1 || mr == 1)){
	 if (my > 1 && my < 22 && mx > 1 && mx < 18){
	  TilePress();      // Test for the Tile Window
	  click=0;
	  if (wrt==1){	wrt=0; k=0;	goto EditDone;}/* END IF */

	  goto GetKey;
	 }else
	 if (my > 13 && my < 22 && mx > 18 && mx < 27 + (wide<<3)){
	  CharPress();       // Test for the Char box
	  goto GetKey;
	 }else
	 if (my2 > 170 && my2 < 175 && mx > 18 && mx < 20+pal[num]){
	  ColorPress();     // Test for the Color change for mouse
	  goto GetKey;
	 }else
	 if (my > 1 && my < 10 && mx > 18 && mx < 35){
	  ClipPress();      // Test for Clip Board stuff
	  goto GetKey;
	 }/* END IF */
  }/* END IF */
/* Mouse tester for Tile retrieval and other */


/* Mouse tester for Menu Bar */
 if (ml == 1 && my == 1 && mx > 1 && mx < 39){
	while(ml==1){
	 MouseStat();
	}
	curs = TestMousePos();
	if (curs > 0){
	  Load_Menu(curs);
	  if (click ==1){
		goto Response;
	  }
	}/* END IF */
	goto GetKey;
 }/* END IF */

 if (ml == 1 && newpal==1 && my == 23 && (bpp[num] == 4 || bpp[num] == 5)){
  if (mx == 19 || mx == 20){
	ButtonDraw(0x0D,178,143,ml);
	ButtonDraw(0x0D,178,143,0);
	key2=0x3300; goto Response;
  }else
  if(mx == 21 || mx == 22){
	ButtonDraw(0x0C,178,160,ml);
	ButtonDraw(0x0C,178,160,0);
	key2=0x3400; goto Response;
  }/* END IF */
 }/* END IF */

 if ((mr == 1 && my > 1) && VGA[(((my <<3)-8)*320+((mx <<3)-8))]== fgc){
	PopUpMenu();
	if (click ==1){
	 goto Response;
	}
	goto GetKey;
 }/* END IF */
 goto GetKey;
/* Mouse tester for Menu Bar */


/****************************************
;  When a Menu Item was chosen, branch  *
;  Here to deal with it.                *
;***************************************/
Response:
 {
  __dpmi_regs r;
  r.h.ah = 0x0C;
  r.h.al = 0;
  __dpmi_int(0x21, &r);
 }

 key2 = key2 & 0xFF00;  // I only want the scan codes

		switch (key2){
/* MOVEMENT KEYS */
		 case 0xFF00 : free(MenuBar); Screen(0x03); SetMemPoint(0);
		               if(strcmp(filnm[1],"") !=0){ free(rombuf[1]); } free(rombuf[0]);
			       exit(0);
	         case 0x4800 : ofs[num]-=128 << pln[num]; k=0; break;      //Up
		 case 0x5000 : ofs[num]+=128 << pln[num]; k=0; break;      //Down
		 case 0x5100 : ofs[num]+=(128*18) << pln[num]; k=0; break; //pgdn
		 case 0x4900 : ofs[num]-=(128*18) << pln[num]; k=0; break; //pgup
		 case 0x4700 : ofs[num] =  0; k=0; break;                  //Home
		 case 0x4F00 : ofs[num]= lof1[num]; k=0; break;            //pgup
		 case 0x4E00 : // +
		 case 0x0D00 : ofs[num]+=(8 << pln[num]); k=0; Waiter(); break; // +
		 case 0x4A00 : // -
		 case 0x0C00 : ofs[num]-=(8 << pln[num]); k=0; Waiter(); break; // -

		 case 0x4D00 : ofs[num]+=1; k=0; Waiter(); break;         // right
		 case 0x4B00 : ofs[num]-=1; k=0; Waiter(); break;         // left

/* MENU ITEM STUFF HERE */
		 case 0x3B00 : HelpScreen(); k=1; break;                  //F1 help
		 case 0x3C00 : ChangeRomFile(); Waiter(); newpal=1; k=0; break;//Change Active Rom F2
		 case 0x3E00 :
		 case 0xE000 : ofs[num] = MessageBox("Enter Address",5,12,3,'A'); k=0; break; //F4  goto
		 case 0x3F00 : //F5
		 case 0xE300 : if (stats==1){ ImportBmp(); k=1; break;// import
		 case 0x4000 : //F6
		 case 0xE400 : MessageBox("Enter BMP File Name",5,12,3,'T'); BMPOpen(); if (strcmp(NOFile,"") !=0){
		               InfoLoad(); if (stats==1){ LoadPal(); DrawBmp(); }} k=0; break;
		 case 0xF100 : if (clr == 1){ CopyPaste(0); k=1;} break; // Paste
		 case 0xE500 : Vblank(); HideMouse(); PixScrFill(143,273,7,73,0,brd,'p'); ShowMouse(); k=1; break; //F9  clear
		 case 0x5500 : if(strcmp(filnm[1],"") != 0){ strcpy(filnm[1],""); lof1[1]=0; pln[1]=0;
		               bpp[1]=0; num=0; free(rombuf[1]);}} k=0; break; // close filnm2
		 case 0x3D00 : MessageBox("Enter File Name",5,12,3,'T'); NewOpenClick(); k=0; break; //F3 open
		 case 0x4200 : //Save F8
		 case 0xE600 : LoadSaveFiles(0, num); k=1; break;

/* TILE MODE STUFF HERE */
		 case 0xDF00 : ChangeCharSize(); k=1; break;
		 case 0x0200 : if (bpp[num] !=0){ bpp[num]=0; pln[num]=0; pos[num]=0; bp4[num]=0; pal[num]=1;  newpal=1; hicol[num]=0; Waiter(); k=0;} break; // 1
		 case 0x0300 : if (bpp[num] !=1){ bpp[num]=1; pln[num]=1; pos[num]=8; bp4[num]=0; pal[num]=3;  newpal=1; hicol[num]=0; Waiter(); k=0;} break; // 2
		 case 0x0400 : if (bpp[num] !=2){ bpp[num]=2; pln[num]=1; pos[num]=1; bp4[num]=0; pal[num]=3;  newpal=1; hicol[num]=0; Waiter(); k=0;} break; // 3
		 case 0x0500 : if (bpp[num] !=3){ bpp[num]=3; pln[num]=2; pos[num]=1; bp4[num]=1; pal[num]=15; newpal=1; hicol[num]=0; Waiter(); k=0;} break; // 4
		 case 0x0600 : if (bpp[num] !=4){ bpp[num]=4; pln[num]=3; pos[num]=1; bp4[num]=2; pal[num]=15; newpal=1; Waiter(); k=0;} break; // 5
		 case 0x0700 : if (bpp[num] !=5){ bpp[num]=5; pln[num]=3; pos[num]=0; bp4[num]=0; pal[num]=15; newpal=1; Waiter(); k=0;} break; // 6
		 case 0x3300 : if (hicol[num] > 000){ hicol[num]-=16; k=0; Waiter(); break;} k=1; break;
		 case 0x3400 : if (hicol[num] < 249){ hicol[num]+=16; k=0; Waiter(); break;} k=1; break;
		 default  : k=1;
		}

EditDone:
	  if (k==1 || k==2){
		mr=0; ml=0;
		goto GetKey;
	  }else{
		DrawTiles();
		Status();
		mr=0; ml=0;
		goto GetKey;
	  }
 return 0;
}
/****************************************
;         THE END OF VOID MAIN          *
;                                       *
;***************************************/





/*********************************
;         Status routine         *
*********************************/
void Status()
{
 char temp[80];

if (my2 > 150 && my2 < 192){
 HideMouse();
}/* END IF */

 sprintf(temp, "Hex: %08lX", ofs[num]);
 TextOut(temp, 15, 0, 2, 24, 's');

 sprintf(temp, "%s", modename[bpp[num]]);
 TextOut(temp, 15, 0, 8, 172,'p');

 PixScrFill(143, 195, 186, 193, 0, brd,'p');         // Percentage Bar
 PixScrFill(144, 145 + (((ofs[num] * 100) / lof1[num])/2), 187, 192, fgc, 0,'p');   // Percentage Bar

 if (pal[num] != cpal[num] || newpal == 1){
  PixScrFill(143, 273, 170, 177, fgc, fgc,'p');      // Clear Excess stuff
  PixScrFill(143, 145+((pal[num]+1)<<3),170,177,0,brd,'p');  // Color Bar
  ColorSet(144, 144, 171, 176, pal[num]);            // Fill the color table
  cpal[num] = pal[num];
 }
 if (my2 > 150 && my2 < 192){
  ShowMouse();
 }/* END IF */
}


/********************************
;Window Routine                 *
********************************/
void WindowBox(int x1, int y1, int x2, int y2)
{
 int xy = 0;
 byte tmp[80];
 byte tmp2[80];

  strfrm((x2 - x1) - 1,'',tmp); //format string with one arguement using variables
  sprintf(tmp2,"%s", tmp);
  TextOut(tmp2, brd, fgc, x1, y1,'s');

  for (xy = y1 + 1; xy < y2; xy++){
	 strfrm((x2 - x1) - 1,' ',tmp);
	 sprintf(tmp2,"%s", tmp);
	 TextOut(tmp2, brd, fgc, x1, xy,'s');
  }
  strfrm((x2 - x1) - 1,'',tmp);
  sprintf(tmp2,"%s", tmp);
  TextOut(tmp2, brd, fgc, x1, y2,'s');

  Shadow(x1 << 3, (x2 << 3) + 6, y2 << 3, (y2 << 3) + 6, 16, 8); // Left / Right
  Shadow((x2 << 3), (x2 << 3) + 6, y1 << 3, (y2 << 3) + 6, 16,8); // Top / Bottom
}



/********************************
;MessageBox Routine             *
********************************/
dwrd MessageBox(char msg[80], int x1, int y1, int y2,char type)
{
 dwrd lngvalue=0;

 char addem, *ep;
 byte tmp[80];
 char MAXX;
 x=0;

 memset(Text,' ' , strlen(msg));
 Text[strlen(msg)]='\0';
 if (type =='A'){
  MAXX = 9;
 }else{
  MAXX = 25;
 }

ReNew:
 Vblank();
 HideMouse();
 pcopy(0,1);

 if (x+1 >= strlen(msg)+2){
  addem = x+2;
 }else{
  addem=strlen(msg) + 2;
 }/* END IF */

 WindowBox(x1, y1, x1 + addem+1, y1 + y2);  // up, lf, rt, dn
 TextOut(msg, brd, fgc, x1+1, y1+1,'s');

 strfrm(addem, ' ',tmp);
 TextOut(tmp, fgc, brd, x1+1, y1 +2, 's');
 TextOut(Text, fgc, brd, x1+1, y1 +2, 's');
 ShowMouse();


InputLoop:
while(!kbhit()){
 MouseStat();
 if ((ml == 1 && my == y1) && (mx > x1-1 && x1 < (x1-1)+strlen(msg))){
  a = mx - x1;
  while(ml == 1){
	MouseStat();
  }
  x1=mx - a; y1=my;

  Vblank();
  HideMouse();
  pcopy(1,0);
  ShowMouse();
  goto ReNew;
 }/*End If */
}/* WEND */


{
 __dpmi_regs r;
  r.h.ah = 0;
  __dpmi_int(0x16, &r);
  n = r.x.ax;
}
 n = n & 0x00FF;

 if ((n == 8 || n == 13 || n == 27 || n > 32) && n < 127){
  switch (n){
	case 27: lngvalue=ofs[num]; click=0; strcpy(NOFile,""); goto LeaveGoto;
	case 13: k=2; break;
	case 8 : k=0; break;
	default: k=1; break;
  }
 }else{
  goto InputLoop;
 }

  if (k==2){     /* IF THE ENTER KEY */
	if (x==0){
	 lngvalue=ofs[num]; click=0;
	 strcpy(NOFile,"");
	}else if(type=='A'){
	 Text[x]='\0';	lngvalue=strtoul(Text, &ep, 16);
	}else if(type=='T'){
	 Text[x]='\0'; strcpy(NOFile,Text);
	}/* END IF */

  }else if (k==1 || k==0){
	if (k==0 && x > 0){
	 x--;	Text[x]=' ';
	 Text[x+1]='\0';

	 Vblank(); HideMouse();
	 if (x+1 >= strlen(msg)+1){addem = x+2; pcopy(1,0);
		WindowBox(x1, y1, x1 + addem+1, y1 + y2);
		TextOut(msg, brd, fgc, x1+1, y1+1,'s');
	  }else{ addem=strlen(msg) + 2;}

	 strfrm(addem, ' ',tmp);
	 TextOut(tmp, fgc, brd, x1+1, y1 +2, 's');
	 TextOut(Text, fgc, brd, x1+1, y1 +2, 's');
	 ShowMouse();
	}else if (k== 1 && x < MAXX){
	 Text[x]=n; Text[x+1]=' '; Text[x+2]='\0';
	 x++;	Vblank(); HideMouse();

	 if (x+1 >= strlen(msg)+1){addem = x+2; pcopy(1,0);
		WindowBox(x1, y1, x1 + addem+1, y1 + y2);
		TextOut(msg, brd, fgc, x1+1, y1+1,'s');
	  }else{ addem=strlen(msg) + 2;}

	 strfrm(addem, ' ',tmp);
	 TextOut(tmp, fgc, brd, x1+1, y1 +2, 's');
	 TextOut(Text, fgc, brd, x1+1, y1 +2, 's');
	 ShowMouse();
	}/* END IF */
	 goto InputLoop;
  }/* END IF */


LeaveGoto:
 memset(Text,'\0' , 128);
 Vblank();
 HideMouse();
 pcopy(1,0);
 ShowMouse();
 return lngvalue;
}


/***************
My page copying*
routine        *
***************/
void pcopy(byte pg1, byte pg2)
{
 if (pg1 == 0 && pg2 == 1){
  memcpy(page1, VGA, SCRN);
 }else
 if (pg1 == 1 && pg2 == 0){
  memcpy(VGA, page1, SCRN);
 }else
 if (pg1 == 0 && pg2 == 2){
  memcpy(MenuBar, VGA, 8 * 320);
 }else
 if (pg1 == 2 && pg2 == 0){
  memcpy(VGA, MenuBar, 8 * 320);
 }
}


/*****************
;FileMenu        *
*****************/
void FileMenu ()
{

 strcpy(men1[0],"Open File F3");
 strcpy(men1[1],"Open BMP  F6");
 strcpy(men1[2],"-");
 strcpy(men1[3],"Save File F8");
 strcpy(men1[4],"-");
 strcpy(men1[5],"Close  Alt-C");
 strcpy(men1[6],"-");
 strcpy(men1[7],"Exit   Alt-X");


 men2[0]=0x3D00; //F3 open
 men2[1]=0xE400; //F6
 men2[2]=0x0000; //NULL
 men2[3]=0xE600; //Save F8
 men2[4]=0x0000; //NULL
 men2[5]=0x5500; //close
 men2[6]=0x0000; //NULL
 men2[7]=0xFF00; //exit

 Max1 = 9;
 menx = 3;
 meny = 2;
 WindowBox(2, meny, 15, 11);
}


/*****************
;EditMenu        *
*****************/
void EditMenu ()
{
if (wide == 1){
 strcpy(men1[0],"Edit 8 x 8  ");
}else{
 strcpy(men1[0],"Edit 8 x16  ");
}
 strcpy(men1[1],"-");
 strcpy(men1[2],"Goto      F4");
 strcpy(men1[3],"-");
 strcpy(men1[4],"View BMP  F5");
 strcpy(men1[5],"Paste BMP   ");

 men2[0]=0xDF00; //tab 8x8/8x16
 men2[1]=0x0000; //NULL
 men2[2]=0xE000; //goto
 men2[3]=0x0000; //NULL
 men2[4]=0xE300; //Import
 men2[5]=0xF100; //Paste

 Max1 = 7;
 menx = 10;
 meny = 2;
 WindowBox(9, meny, 22, 9);
}


/*****************
;Options Menu    *
*****************/
void OptsMenu ()
{
 strcpy(men1[0],"Switch File  F2");
 strcpy(men1[1],"-");
 strcpy(men1[2],"Clear ClipBoard");

 men2[0]=0x3C00; //Change Active Rom
 men2[1]=0x0000; //NULL
 men2[2]=0xE500; //Clear clipboard

 Max1 = 4;
 menx = 17;
 meny = 2;
 WindowBox(16, meny, 32, 6);
}


/*****************
;Help Menu       *
*****************/
void HelpMenu ()
{
 strcpy(men1[0],"Help   F1");
 men2[0]=0x3B00; //F1 help

 Max1 = 2;
 menx = 30;
 meny = 2;
 WindowBox(29, meny, 39, 4);
}


/********************
;Pop Up menu routine*
********************/
void PopUpMenu()
{
 while (mr == 1){
  MouseStat();
 }

if (wide == 1){
 strcpy(men1[0],"8 x 8  ");
}else{
 strcpy(men1[0],"8 x 16 ");
}
 strcpy(men1[1],"-");
 strcpy(men1[2],"Goto F4");
 strcpy(men1[3],"-");
 strcpy(men1[4],"Exit   ");

 men2[0]=0xDF00; //tab 8x16/8x8
 men2[1]=0x0000; //NULL
 men2[2]=0xE000; //F4  goto
 men2[3]=0x0000; //NULL
 men2[4]=0xFF00; //ESC exit


DoReset:
 Max1 = 6;
 menx = mx;
 meny = my;
 xy = my -2;
 rst = 0;

 if (my > 1 && VGA[(((my <<3)-8)*320+((mx <<3)-8))] == fgc){
  Load_Menu(10);
  if (rst == 1){
	goto DoReset;
  }
 }/* END IF */

 if (click == 0){
  Waiter();
 }/* END IF */
  xy=0;
}


/****************************************
;Routine to format any char for a number*
;of times specified by 'cnt'            *
****************************************/
void strfrm(byte cnt, byte ch, byte stg[80])
{
 int g;

 stg[0] = ch;
 for (g=1; g < cnt; g++){
  stg[g] = ch;
 }
 stg[g]='\0';
}



/******************
;Init the mouse   *
******************/
void InitMouse()
{
  __dpmi_regs r;
  r.x.ax = 0;
  __dpmi_int(0x33, &r);

}


/******************
;Init the mouse   *
******************/
void ShowMouse()
{
  __dpmi_regs r;
  r.x.ax = 1;
  __dpmi_int(0x33, &r);
}


/******************
;Hide the mouse   *
******************/
void HideMouse()
{
  __dpmi_regs r;
  r.x.ax = 2;
  __dpmi_int(0x33, &r);
}

/*******************
;Chack Mouse Status*
*******************/
void MouseStat()
{
  __dpmi_regs r;

  r.x.ax = 3;
  __dpmi_int(0x33,&r);

  mx2 = r.x.cx;
  my2 = r.x.dx;

  mx = (r.x.cx >> 4) + 1;
  my = (r.x.dx >> 3) + 1;

  mx2 = mx2 >> 1;

  ml = (r.x.bx & 1);           // Mouse Left
  mr = ((r.x.bx & 2) >> 1);    // Mouse Right

//  gotoxy(20,21); printf("%02d %02d %02d %02d %03d %03d", mx, my, ml, mr, my2, mx2);
}


/******************
;Main Menu loader *
******************/
void Load_Menu(byte curs)
{
 int curx=1;
 char trc=0;

 Vblank();
 HideMouse();
 pcopy(0, 2);

 if (curs != 10){
  TextOut(" File   Edit   Options             Help " ,brd, fgc, 1, 1,'s');
 }/* END IF */

 ShowMouse();

NextMenu:
 Vblank();
 HideMouse();
 pcopy(0,1);

 if (curs != 10){
  if (curs < 1){
	curs = 4;
  }else if (curs > 4 && curs != 10){
	curs = 1;
  } /* END IF */

  switch(curs){
	case 1: FileMenu(); break;
	case 2: EditMenu(); break;
	case 3: OptsMenu(); break;
	case 4: HelpMenu(); break;
  }
 }else{
  WindowBox(mx - 1, meny, mx + 7, my + 6);
 }


/**** Universal Menu Functions *****/
curx=1;
MainMenu:
 Vblank();
 HideMouse();
 ShowMenu(xy, curx);
 ShowMouse();

MenuMove:
while (!kbhit()){    /* Test for any Button */
  MouseStat();
  if ((mx > menx-1 && mx < menx + strlen(men1[0])) && my < (Max1 + xy)+ 2){
	if (strcmp(men1[(my-xy)-3],"-") != 0 && curx != (my - xy) - 2 && (my - xy) - 3 >= 0){
	 curx = (my - xy) - 2;
	 goto MainMenu;
	} /* End If - Mouse Test */
  } /* End If */

/* Choose a menu item Label */
  if (ml == 1 && curs != 10 && my == 1){
	curs = TestMousePos();
	if (trc != curs){
	 trc = curs;
	 HideMouse();
	 pcopy(1,0); ShowMouse();
	 goto NextMenu;
	}/* END IF */
  }/* END IF */
/* Choose a menu item Label */


/* Escape the menu system */
  if (ml == 1 && (mx < menx - 1 || mx > menx + strlen(men1[0]) || my > Max1 + xy + 2 || my < meny) && my !=1){
	 while(ml ==1){
	  MouseStat();
	 }/* WEND */
	 goto MenuLeave;
  }/* END IF */
/* Escape the menu system */


/* Choose a menu item */
  if(ml == 1 && strcmp(men1[(my-xy)-3],"-") != 0 && (my-xy)-3 < Max1-1  && my !=1 && (my-xy)-3 > -1){
	if (mx > menx - 1 && mx < menx + strlen(men1[0])){
	 key2 = men2[(my-xy)-3];
	 click=1;
	 while(ml ==1){
	  MouseStat();
	 }/* WEND */
	 goto MenuLeave;
	}/* END IF */
  }/* END IF */
/* Choose a menu item */


/* Escape the main menu or choose Popup Menu */
  if (mr == 1 && (mx < menx - 1 || mx > menx + strlen(men1[0]) || my > Max1 + xy + 2 || my < xy + 1)){
	while(mr == 1){
	 MouseStat();
	}
	key2=0;
	rst =1;
	goto MenuLeave;
  }
/* Escape the main menu or choose Popup Menu */
}/* WEND - Test for any Button */


/* All-Key tester */
{
  __dpmi_regs r;
  r.h.ah = 0;
  __dpmi_int(0x16, &r);
  n = r.x.ax;
}
 n = n & 0xFF00;

 switch (n){
	case 0x0100 : key2 =0; click =0; goto MenuLeave;
	case 0x1C00 : key2 = men2[curx-1]; click=1; goto MenuLeave;
	case 0x4800 : goto AdjustUp;
	case 0x5000 : goto AdjustDn;
	case 0x4D00 : curs +=1; HideMouse(); pcopy(1,0); ShowMouse();goto NextMenu;
	case 0x4B00 : curs -=1; HideMouse(); pcopy(1,0); ShowMouse();goto NextMenu;
	default     : goto MenuMove;
 }



/* Update the up key press stuff */
AdjustUp:
 curx -=1;
 if (strcmp(men1[curx - 1],"-") == 0){
  curx -=1;  /* Null Bar Test */
 }
 if (curx < 1){
  curx = Max1 - 1;
 }

HideMouse();
ShowMenu(xy, curx);
ShowMouse();
goto MenuMove;
/* RETURN */


/* Update the Down key press stuff */
AdjustDn:
 curx +=1;
 if (strcmp(men1[curx - 1],"-") == 0){
  curx +=1;  /* Null Bar Test */
 }
 if (curx > Max1 - 1){
  curx = 1;
 }

HideMouse();
ShowMenu(xy, curx);
ShowMouse();
goto MenuMove;
/* RETURN */


MenuLeave:
 if (click == 0){
  Waiter();
 }

{
 __dpmi_regs r;
  r.h.ah = 0x0C;
  r.h.al = 0;
  __dpmi_int(0x21,&r);
}

 HideMouse();
 pcopy(1,0);
 pcopy(2,0);
 ShowMouse();
}



/******************
;Print the data in*
;Menu Bars        *
******************/
void ShowMenu(byte xy, byte curx)
{
 byte tmp[80];
 byte tmp2[80];
 char cc;


for (cc = 1; cc < Max1; cc++){
 if (strcmp(men1[cc - 1],"-") == 0){
  strfrm(strlen(men1[0]),'',tmp);
  sprintf(tmp2,"%s", tmp);
  TextOut(tmp2, brd, fgc, menx - 1, xy + cc + 2,'s');
  goto NullBar2;
 }else{
  if (curx == cc){
	TextOut(men1[cc - 1], fgc, brd, menx, xy + cc + 2,'s');
  }else{
	TextOut(men1[cc - 1], brd, fgc, menx, xy + cc + 2,'s');
  }
 }

NullBar2:
} /* Next cc */

 ShowMouse();
}/* RETURN */


/*************************
;Print text with defined *
;color attributes        *
*************************/
void TextOut(byte txt[80], byte txtclr, byte bckclr,
 byte x, byte y, char type)
{

 int l;
 int v,h,f;

 if (type == 's'){
  memx = (x << 3) - 8;
  memy = (y << 3) - 8;
 }else{
  memx = x;
  memy = y;
 }

 l = strlen(txt);

 for (v = 0; v < l; v++){        /* Each Column */
  for (h = 0; h < 8 ; h++){       /* Each Row */
	dec = 0x80;
	for (f = 0; f < 8; f++){      /* Each Pixel */
	 ty = (memy + h) << 6;        /* y position */
	 tx = ty << 2;                /* multiplied by 320 */
	 ty += tx + memx;

	 if (txt[v] < 128){
	  col = (font[((txt[v]-32) << 3) + h] & dec) / dec;
	 }else{  /* IF IT'S THE MENU CHARS */
	  if (txt[v] < 181 && txt[v] > 178){
		col = (hichar[((txt[v]-179) << 3) + h] & dec) / dec;
	  }else if(txt[v] < 193 && txt[v] > 190){
		col = (hichar[(((txt[v]-191) + 2) << 3) + h] & dec) / dec;
	  }else if(txt[v] < 197 && txt[v] > 194){
		col = (hichar[(((txt[v]-195)+4) << 3) + h] & dec) / dec;
	  }else if(txt[v] < 219 && txt[v] > 216){
		col = (hichar[(((txt[v]-217)+6) << 3) + h] & dec) / dec;
	  }/* END IF */
	 }
	 dec = dec >> 1;

	 if (col==1){
	  VGA[ty + (v << 3)+f] = txtclr;
	 }else{
	  VGA[ty + (v << 3)+f] = bckclr;
	 } /* End If */
	}/* Next f */
  } /* Next v */
 } /* Next h */
}/* END SUB */



/************************
;Draw the tiles for me! *
;All bitplane graphics  *
;routines here...       *
************************/
void DrawTiles()
{

 inc = 0;
 cpos=0;


 if (ofs[num] <= 0){                 /* Determine correct file position */
  ofs[num] = 0;
 }else if (ofs[num] + ((128 * 18) << pln[num]) >= lof1[num]){
  ofs[num] = lof1[num] - ((128 * 18) << pln[num]);
 }/* END IF */


 for (I = 0; I < 0x14; I++){     /* Each tile row */
  for (j =0; j < 0x80; j+=8){    /* Each tile column */

	if (bpp[num] == 1 || bpp[num] == 2 || bpp[num] == 3 || bpp[num] == 4){   /* If NES, SNES, and GB Mode */
	 memcpy(Text, &rombuf[num][ofs[num] + cpos], (16 << bp4[num]));
	 cpos+= (16 << bp4[num]);
	}

	for (bp = 0; bp < 8; bp++){  /* Loop through all tiles */
/************************************
;        1-Bit Tile Mode            *
;     Uses z for bit test loop      *
************************************/
	if (bpp[num] == 0){
	 c = rombuf[num][ofs[num] + cpos];
         cpos++;
	 dec = 0x80;
	 for (z = 0; z < 8; z ++){    /* Loop through all tile lines */
		col = (c & dec) / dec;
		dec = dec >> 1;
		BitDraw(col);
	 }/* Next z - next tile row */
/************************************
;    NES/GB/SNES/8BIT Tile Mode     *
;     Uses z also for bit test loop *
************************************/
	}else if(bpp[num] == 1 || bpp[num] == 2 || bpp[num] == 3 || bpp[num] == 4 || bpp[num] == 5){
	 dec=0x80;

	 for (z = 0; z < 8; z ++){             /* Loop through all tile lines */
	  if (bpp[num] ==2 || bpp[num] == 1){  /* THE NES/GB TEST */
		if (bpp[num] == 2){ inc = bp; }else{ inc = 0;}
		 col = ((Text[bp + inc] & dec) / dec) * 1;
		 col += ((Text[bp + pos[num] + inc] & dec) / dec) * 2;
	  }else if (bpp[num] == 3 || bpp[num] == 4){   /* THE SNES TEST */

		 col = ((Text[bp + bp] & dec) / dec) * 1;
		 col += ((Text[bp + 1 + bp] & dec) / dec) * 2;
		 col += ((Text[bp + 16 + bp] & dec) / dec) * 4;
		 col += ((Text[bp + 17 + bp] & dec) / dec) * 8;
		if (bpp[num] == 4){                    /* 8 - BIT TEST */
		 col += ((Text[bp + 32 + bp] & dec) / dec) * 16;
		 col += ((Text[bp + 33 + bp] & dec) / dec) * 32;
		 col += ((Text[bp + 48 + bp] & dec) / dec) * 64;
		 col += ((Text[bp + 49 + bp] & dec) / dec) * 128;
		}/* END IF */

	  }else if (bpp[num] == 5){
	   col = rombuf[num][ofs[num] + cpos];
           cpos++;
	  }/* END IF */
	  dec = dec >> 1;
	  BitDraw(col);
	 }/* Next z - next tile row */
	} /* End If for Bit Test */
	}/* Next bp - next tile */
  } /* next j */
 } /* Next I */

 Vblank();
 HideMouse();

 /* DRAW DATA FROM BUFFER */
 for (a1 = 8; a1 < 168; a1++){
  memcpy(&VGA[(a1 * 320) + 8], &buffr[(a1 * 320)], 128);
  a2 +=128;
 }
 ShowMouse();
}/* End Sub */


/**********************
;Universal Pixel Draw *
**********************/
void BitDraw(byte cl)
{
 ypos = (((I + 1)<<3) + bp) << 6;  /* Get the y LINEAR position */
 sp = (ypos) << 2;                 /* Multiply it by 320 */
 ypos += sp + j + z;               /* add the tile inc plus xpos */
 buffr[ypos] = cl;                 /* Store it in the buffer */
}



/***********************
;Wait for a few seconds*
***********************/
void Waiter()
{
 for (cx = 0; cx < 0xFFFF; cx++){
  for (dx = 0; dx < 0x70; dx++){
  }/* Next dx */
 }/* Next cx */
}/* End Sub */



/***********************************
; Pixel / Screen relative filler   *
; x1 = Top left, y1 = Bottom left  *
; x2 = Top right, y2 = Bottom right*
; color = attribute                *
***********************************/
void PixScrFill(word x1, word x2, word y1, word y2, byte color, char border, char type)
{

 if (type == 's'){  /* Relative to screen coordinates */
	a1 = ((x2 << 3) - ((x1 << 3) - 8));
	x1 = (x1 << 3) - 8;
	y1 = (y1 << 3)-8;
	y2 = (y2 << 3);
 }else{             /* Pixel locations */
	a1 = x2 - x1;
 }/* END IF */

  for (b1 = y1; b1 < y2; b1++){
	a2 = (b1 * 320) + x1;

	if (border != -1 && act == 1){                  // top Border test
	 memset(&VGA[a2], border, a1);
	 act = 0;
	}else
	if (border != -1 && act == 0 && b1 + 1 == y2){  // bottom border test
	 memset(&VGA[a2], border, a1);
	}else{
	 memset(&VGA[a2], color, a1);
	}/* END IF */

	if (border != -1){
	 VGA[a2] = border;
	 VGA[(a2 + a1) - 1] = border;
	}/* END IF */
  }/* Next b1 */
  act=1;
}/* END SUB */


/**********************************
;		    Set Color Bar           *
**********************************/
void ColorSet(int x1, int x2, int y1, int y2, char pal)
{
  a1 = x2 - x1;

  for (b2 = 0; b2 < pal+1; b2++){    // Color Loop
	for (b1 = y1; b1 < y2; b1++){     // Up / Down
	 for (xcrd=0; xcrd < 8; xcrd++){  // Left / Right
	  a2 = (b1 * 320) + x1;
	  VGA[a2 + xcrd + (b2 << 3)] = b2+hicol[num];
	 } /* NEXT xcrd */
	} /* NEXT b1 */
  }/* NEXT b2 */
}/* END SUB */


/**********************************
;		    Shadow Detail           *
**********************************/
void Shadow(word x1, word x2, word y1, word y2, byte color, char border)
{

  for (b1 = y1; b1 < y2; b1++){
	for (b2 = x1; b2 < x2; b2++){
	 a2 = (b1 * 320) + b2;
	 if (VGA[a2] == 15 || VGA[a2] == border || VGA[a2] == 7 || VGA[a2] ==3 || VGA[a2] == brd){
	  VGA[a2]= border;
	 }else{
	  VGA[a2]= color;
	 }/* END IF */
	}/* NEXT b2 */
  }/* NEXT b1 */
}/* END SUB */


/*********************
;Universal Menu Call *
;Tester for mouse    *
*********************/
word TestMousePos()
{
 if (my == 1 && curs != 10){
	if(mx > 1 && mx < 6 && curs !=1){
	 curs =1;
	}else if(mx > 8 && mx < 13 && curs !=2){
	 curs = 2;
	}else if(mx > 15 && mx < 23 && curs !=3){
	 curs = 3;
	}else if(mx > 35 && mx < 40 && curs !=4){
	 curs = 4;
	} /* END IF */
  } /* END IF */
  if (curs == 0){
	curs = 1;
  }
  return curs;
}/* END SUB */



/************************
;Draw the 100% word to  *
;the screen             *
*************************/
void PerCent()
{
 for (a1 = 0; a1 < 3; a1++){   /* NEXT Tile */
  for (b1 = 0; b1 < 8; b1++){  /* NEXT Line */
	dec=0x80;
	for (a2 = 0 ; a2 < 8; a2++){ /* NEXT Pixel */
	 if ((col = ((hun[(a1 << 3) + b1] & dec) / dec) * brd) > 0){
	  VGA[((185 + b1) * 320) + (199 + a2) + (a1 << 3)] = col;
	 }/* END IF */
	 dec = dec >> 1;
	}/* NEXT a2 */
  }/* NEXT b1 */
 }/* NEXT a1 */
}/* RETURN */



/********************************
;React to the left mouse button *
;For the Tile window            *
********************************/
void TilePress()
{

 Vblank();
 HideMouse();

 ycrd = ((my - 1) << 3);          // current y  - for screen pixel retrieval
 xcrd = ((mx - 1) << 3);          // current x
 addy = 0;

 if (ml == 1){                    // We want to get the tile
	for (a2 = 0; a2 < 8; a2++){    //get 8 line count
	 for (b1=0; b1 < (8 << (wide-less)); b1++){       //get the column row of pixels

	  col = VGA[(ycrd + a2) * 320 + (xcrd + b1)];
	  if (mx == 17 && wide == 1){ less = 1;}else{less = 0;}
	  for (b2=0; b2<8; b2++){
		for (a1=0; a1 < 8; a1++){
		 VGA[((((14+a2)<<3)-8)+a1) * 320 + (((19+b1)<<3)-8)+b2] = col;
		}/* Next a1 */
	  }/* Next b2 */

	 } /* NEXT a2 */
	} /* NEXT a1 */
	goto ImDone;
  }/* END IF */
/********************************
;React to the right mouse button*
;For the Tile window            *
********************************/
 if (mr == 1){                               // we want to put the tile
	memset(Text, '\0', 128);                   //clear the buffer
	/* get the file position based on mouse and file position */
	plc = (((((my-2)<< 3)<< 4) <<pln[num]) + (((mx-2)<<3)<< pln[num])) + ofs[num];

  ForAddy:                                   //here to add the wide chars
	for (a2 = 0; a2 < 8; a2++){
	 dec= 0x80;
	 for (b1=0; b1 < 8; b1++){                //get the column row of pixels
	  col = VGA[(((14+a2)<<3) - 8) * 320 + ((((19+addy)  + b1) << 3) - 8)];
	  if (bpp[num] == 0){                      /* TEST THE  1-BIT MODE */
		if (col < 2){
		 Text[a2 + (addy<<pln[num])] += col * dec;
		}
		dec = dec / 2;
	  }else if(bpp[num] == 1 || bpp[num] == 2){     /* GB and SNES 2 - Bit */
		if (col < 4){
		 if (bpp[num] == 2){ inc = a2; }else{ inc = 0;}
		 Text[a2 + inc + (addy<<pln[num])] += ((col & 1) * dec);
		 Text[a2 + pos[num] + inc + (addy<<pln[num])] += (((col & 2) / 2) * dec);
		}
		dec = dec / 2;
	  }else if (bpp[num] == 3 || bpp[num] == 4){    /* SNES 4 - Bit */
		  Text[a2 + a2 + (addy<<pln[num])] += ((col & 1) * dec);
		  Text[a2 + 01 + a2+ (addy<<pln[num])]  += (((col & 2)/2) * dec);
		  Text[a2 + 16 + a2+ (addy<<pln[num])] += (((col & 4)/4) * dec);
		  Text[a2 + 17 + a2+ (addy<<pln[num])] += (((col & 8)/8) * dec);
		if(bpp[num] == 4){                      /* FOR THE 8 - Bit Tiles */
		  Text[a2 + 32 + a2 + (addy<<pln[num])] += (((col & 16)/16) * dec);
		  Text[a2 + 33 + a2 + (addy<<pln[num])]  += (((col & 32)/32) * dec);
		  Text[a2 + 48 + a2 + (addy<<pln[num])] += (((col & 64)/64) * dec);
		  Text[a2 + 49 + a2 + (addy<<pln[num])] += (((col & 128)/128) * dec);
		}/* END IF */
		 dec = dec / 2;
	  }else if (bpp[num] == 5){                /* RAW BYTE MODE */
		 Text[(a2<<3) + b1 + (addy<<pln[num])] =col;
		 dec = dec / 2;
	  }/* END IF */
	 } /* NEXT b1 */
	} /* NEXT a2 */
	if (wide == 1 && addy == 0){ addy = 8; goto ForAddy;} else { addy = 0;}
        memcpy(&rombuf[num][plc], Text, (8 << pln[num]) << wide);
	wrt=1;
  }/* END IF */

ImDone:
 ShowMouse();
}



/********************************
;React to the left mouse button *
;For the Clip Board             *
********************************/
void ClipPress()
{
 ycrd = ((my - 1) << 3);          // current y  - for screen pixel retrieval
 xcrd = ((mx - 1) << 3);          // current x
 less = 0;

 Vblank();
 HideMouse();

 if (ml == 1){                     // Paste from Clip Board
  for (a2 = 0; a2 < 8; a2++){      //get 8 line count
	for (b1=0; b1 < (8 << (wide-less)); b1++){       //get the column row of pixels
	 if (mx == 34 && wide == 1){ less = 1;}else{ less = 0;}
	 col = VGA[(ycrd + a2) * 320 + (xcrd + b1)];

	 for (b2=0; b2<8; b2++){
	  for (a1=0; a1 < 8; a1++){
		VGA[((((14+a2)<<3)-8)+a1) * 320 + (((19+b1)<<3)-8)+b2] = col;
	  } /* NEXT a1 */
	 } /* NEXT b2 */
	} /* NEXT a2 */
  } /* NEXT a1 */
/********************************
;React to the right mouse button*
;For the Clip Board             *
********************************/
 }else if (mr == 1){                    // Paste to Clip Board
  if (mx == 34 && wide == 1){ less = 1;}
  for (a2 = 0; a2 < 8; a2++){           //get 8 line count
	for (b1=0; b1 < (8 << (wide-less)); b1++){  //get the column row of pixels
	 col = VGA[(((14+a2)<<3)-8) * 320 + (((19+b1)<<3)-8)];
	 VGA[(ycrd+a2)*320+(xcrd+b1)]=col;   //set the pixel according to the find
	} /* NEXT a2 */
  } /* NEXT a1 */
 }/* END IF */
  ShowMouse();
}/* END SUB */



/********************************
;React to the left & right mouse*
;button for the Char window     *
********************************/
void CharPress()
{
 char msl = ml;
 char msr = mr;


 if (msl == 1){
  col = mlc;
 }else if (msr == 1){
  col = mrc;
 }

 Vblank();
 gotoxy(mx, my);       //print eight rows, all colors

 HideMouse();

 // print the char with color
{
  __dpmi_regs r;

  r.h.al = 219;
  r.x.cx = 1;
  r.h.ah = 10;
  r.h.bl = col;
  r.h.bh = 0;
  __dpmi_int(0x10,&r);
}

 ShowMouse();
}


/********************************
;React to the left & right mouse*
button for the Tile window      *
********************************/
void ColorPress()
{
 char msl = ml;
 char msr = mr;

 while(ml == 1 || mr == 1){
  MouseStat();
 }

 Vblank();
 HideMouse();

 if (msl == 1){
  mlc = ClickColor(my2, mx);
 }else if (msr == 1){
  mrc = ClickColor(my2, mx);
 }

 PixScrFill(231, 238, 187, 192, mlc, mlc,'p');   // Mouse Color left
 PixScrFill(238, 245, 187, 192, mrc, mrc,'p');   // Mouse Color right
 ShowMouse();
}


/********************************
;Use mouse values to obtain the *
;colors to store in the editor  *
********************************/
int ClickColor(int val1, int val2)
{
 return VGA[val1 * 320 + ((val2 << 3)-8)];
}


/******************
;Draw the buttons *
******************/
void ButtonDraw(char chr, byte y, byte x, char but)
{
 if (chr != 0){
  chr=chr-0x0C;       // Set for Indexing;
  chr=(chr<<5) + (but<<4);   // Shift by 16 for minus if = 1
 }else{
  chr=(2<<5) + (but<<4);
 }

 Vblank();
 HideMouse();

 for (a1=0; a1 < 8; a1++){
  dec = 0x8000;
  for (b1=0; b1 < 16; b1++){
	col = ((buttons[chr+a1] & dec)/dec)* 1;
	col+= ((buttons[chr+a1 + 8] & dec)/dec)*2;
	if (col == 1){
	 col = 8;
	}else if((col==2 || col == 0) && chr != (2<<5)){
	 col = 7;
	}else if (col==3){
	 col = 15;
	}else if (chr == 2<<5){
	 col = 127;
	}
	VGA[(y+a1) * 320 + (x+b1)]=col;
	dec = dec >> 1;
  }/* NEXT b1 */
 }/* NEXT a1 */
 ShowMouse();
 while(ml==1){
  MouseStat();
 }
}


/************************
;Routine to swicth rom  *
;files for editing, if  *
;there are 2 rom files  *
************************/
void ChangeRomFile()
{
 if (strcmp(filnm[1],"") != 0){
  if (num == 1){
	num =0;
  }else{
	num = 1;
  }/* END IF */
 }/* END IF */
}


/************************
;Routine to close rom   *
;files and open them    *
************************/
void LoadSaveFiles(char flag, char rom)
{
 char temp[80];

 if (flag == 0){    // If saving data
  if ((fil[rom] = fopen(filnm[rom],"r+b")) != NULL){
   fwrite(rombuf[rom], sizeof(byte), lof1[rom], fil[rom]);
   strcpy(temp,"File was saved...");
   fclose(fil[rom]);
  }else{
   strcpy(temp,"File Not Found...");
  }/* END IF */
    Vblank();
    HideMouse();
    pcopy(0,1);
    WindowBox(6, 6, 26, 8); // across, down, top start, bottom start
    TextOut(temp,brd,fgc,7,7,'s');
    ShowMouse();
    while(!kbhit()){
    }


    Vblank();
    HideMouse();
    pcopy(1,0);
    ShowMouse();
 }else{
  fil[rom] = fopen(filnm[rom],"r+b");
  if ((rombuf[rom] = (byte *) malloc(lof1[rom])) == NULL){
   printf("Not enough memory to allocate for %s", filnm[rom]);
   exit(1);
  }else{
   fread(rombuf[rom], sizeof(byte), lof1[rom], fil[rom]);
   fclose(fil[rom]);
  }/* END IF */
 }
}



/************************
;Routine to Add new file*
************************/
void NewOpenClick()
{

  if ((hnd = open(NOFile,O_BINARY)) != -1 && strcmp(filnm[0],NOFile) !=0){
    if (strcmp(filnm[1],"") != 0){
      free(rombuf[1]);
    }/* EMD IF */
    lof1[1] = filelength(hnd);
    _close(hnd);
    fclose(fil[1]);
    strcpy(filnm[1],NOFile);

    LoadSaveFiles(1, 1);
    Vblank();
    HideMouse();
    pcopy(0,1);

    WindowBox(6, 6, 29, 8); // across, down, top start, bottom start
    TextOut("File Now Available...",brd,fgc,7,7,'s');
    ShowMouse();
  }else{
    Vblank();
    HideMouse();
    pcopy(0,1);
    WindowBox(6, 6, 26, 8); // across, down, top start, bottom start

    if (strcmp(filnm[0],NOFile) == 0){
     TextOut("File Already Open..",brd,fgc,7,7,'s');
    }else{
     TextOut("File Not Found...",brd,fgc,7,7,'s');
    }/* END IF */
    ShowMouse();
  }/* END IF */

  getch();
  Vblank();
  HideMouse();
  pcopy(1,0);
  ShowMouse();
}/* END SUB */


/*************************
;Simple routine for the  *
;Box cursor used in the  *
;BMP function            *
*************************/
void Box(word y, word x) // x cord
{
 bmy = y;
 bmx = x;
 bmd = (y+8) + MaxY;
 bme = (x+8) + MaxX;

 memset(&VGA[y*320+x], 4, bme - x);
 memset(&VGA[(bmd-1)*320+x], 4, bme - x);
 for (a1=0; a1 < bmd - y; a1++){
  VGA[(y+a1)*320+x]=4;
  VGA[(y+a1)*320+bme]=4;
 }
}


/*************************
;Routine to change the   *
;Char box size           *
*************************/
void ChangeCharSize()
{
 word memy;
 Waiter();

  if (wide==0){ wide=1;}else{ wide=0;}
  Vblank(); HideMouse();

  memy =0;                          // Get the old stuff first
  for (a1=0; a1 < 64; a1++){
	memcpy(&charb[memy], &VGA[((104+a1)*320)+144], 64);
	memy+=64;
  }/* NEXT a1 */

  PixScrFill(209, 273, 103, 169, fgc, fgc,'p');
  PixScrFill(143, 209+(wide<<6), 103, 169, 0, brd,'p');

  memy =0;                          // Put the old stuff bck
  for (a1=0; a1 < 64; a1++){
	memcpy(&VGA[((104+a1)*320)+144], &charb[memy], 64);
	memy+=64;
  }/* NEXT a1 */
  ShowMouse();
}/* END SUB */



/*************************
;Command Load routine    *
*************************/
void CommandLoad(int argc, char *argv[])
{
 if (argc > 1){
  strcpy(filnm[0],argv[1]);
  if ((hnd = open(filnm[0],O_BINARY)) != -1){
   lof1[0] = filelength(hnd);
   _close(hnd);
   LoadSaveFiles(1,0);
  }else{
   exit(1);
  }/* END IF */

  if (strcmp(argv[2],"") != 0){
    strcpy(filnm[1],argv[2]);
    if ((hnd = open(filnm[1],O_BINARY)) != -1){
     lof1[1] = filelength(hnd);
     _close(hnd);
     LoadSaveFiles(1,1);
    }else{
     strcpy(filnm[1],"");
    }/* END IF */
  }/* END IF */
 }else{
  printf("Usage:\n%s <romname.ext> [OPTION] <romname2.ext>\nProgram coded by John C. [ Bongo`]",argv[0]);
  exit(1);
 }/* END IF */
}/* RETURN */



/*************************
;Help screen sub routine *
*************************/
void HelpScreen()
{
 char cur=0;
 word chr=0;

 Vblank();
 HideMouse();
 pcopy(0,1);
 Screen(0x03);

 textbackground(0);
 clrscr();
 textcolor(15);
 textbackground(3);


 cprintf("                          Tile - Edit Version 0.99 Final     Press Up / Down key");
 textbackground(0);
 NoCursor();

ReStart:
 for (x=1; x < 24; x++){
  if (x+cur < 76){
	if (hbuf[x+cur-1][0]=='-'){
	 gotoxy(1,x+1); textbackground(1); cprintf("%80c",' ');
	 gotoxy(1,x+1); cprintf("%s",hbuf[x+cur-1]);
	}else{
	 gotoxy(1,x+1); textbackground(0); cprintf("%80c",' ');
	 gotoxy(1,x+1); cprintf("%s",hbuf[x+cur-1]);
	}/* END IF */
  }else{
	gotoxy(1,x); cprintf("%80c",' ');
	break;
  } /* END IF */
 }/* Next x */


GetChar:
 chr = inportb(0x60);
 if (chr & 0x80){
  goto GetChar;
 }/* END IF */


 Vblank();
 Vblank();
  switch(chr){
	case 0x01: goto DoneHelp;
	case 0x48: if (cur > 0){ cur--; goto ReStart;} goto GetChar;
	case 0x50: if (cur <76-24){ cur++; goto ReStart;} goto GetChar;
	default  : goto GetChar;
  }

DoneHelp:
 Screen(0x13);
 pcopy(1,0);
 ShowMouse();
}



/***************************
;The routine area to import*
;the BMP and the controls  *
***************************/
void ImportBmp()
{
/* Init The screen */
 HideMouse();
 pcopy(0,1);						// Save Tile Window
 memset(VGA, '\0', SCRN);     // Clear the screen

 Vblank();                    // Wait for retrace
 if (bits == 8 || bits == 4){
  SetPal(0);                  // Set the palette
 }
 memcpy(VGA, imprt, SCRN);    // Move the BMP data to the screen
 Box(cry, crx);               // Print My Cursor Box
 ShowMouse();                 // Show The mouse
/* Init The screen */


/* Start Main Control routine */
GetPress:
 Vblank();
 MouseStat();
 if (ml == 1){
	cry = my2, crx = mx2;
	goto ReFresh;
 }else if (mr==1){
  keyy = 0x99;
  while(mr==1){
	MouseStat();
  }
  goto DoKey;
 }/* END IF */

  keyy = inportb(0x60);
  if (keyy & 0x80){
   goto GetPress;
  }


DoKey:
  switch(keyy){
	case 0x01: Screen(0x13); InitMouse(); ShowMouse(); goto DoneBmp;
	case 0x99: Waiter(); CopyPaste(1); clr = 1; goto ReFresh;
	case 0x53: Waiter(); memset(copy, '\0', 0x2000); clr = 0; goto ReFresh;
	case 0x0F: if (nomove == 0){ nomove = 1; }else{ nomove = 0;} LetItGo(); goto GetPress;
	case 0x48: if (MaxY + 8 > 8 && clr==0 && nomove ==1){ MaxY--; goto ReFresh;}
				  else if (nomove ==0){ goto DoUp;} goto BadMsg;
	case 0x50: if (MaxY + 8 < 64 && clr==0 && nomove ==1){ MaxY++; goto ReFresh;}
				  else if (nomove ==0){ goto DoDn;} goto BadMsg;
	case 0x4D: if (MaxX + 8 <128 && clr==0 && nomove ==1){ MaxX++; goto ReFresh;}
				  else if (nomove ==0){ goto DoRt;} goto BadMsg;
	case 0x4B: if (MaxX + 8 > 8 && clr==0 && nomove ==1){ MaxX--; goto ReFresh;}
				  else if (nomove ==0){ goto DoLt;} goto BadMsg;
	default  : goto GetPress;
  }/* END SWITCH */


ReFresh:
 Vblank();
 HideMouse();
 memcpy(VGA, imprt, SCRN);
 Box(cry, crx);
 ShowMouse();
 goto GetPress;
 /* RETURN */


DoUp:
if (cry > 0){
 cry--;
 goto ReFresh;
}
goto GetPress;
/* RETURN */


DoDn:
if (cry + MaxY + 8 < 200){
 cry++;
 goto ReFresh;
}
goto GetPress;
/* RETURN */


DoLt:
if (crx > 1){
 crx--;
 goto ReFresh;
}
goto GetPress;
/* RETURN */


DoRt:
if (crx + MaxX + 8 < 319){
 crx++;
 goto ReFresh;
}
goto GetPress;
/* RETURN */


BadMsg:
if (clr == 1){
 LetItGo();
 {
  __dpmi_regs r;
  r.h.ah = 0x0C;
  r.h.al = 0;
  __dpmi_int(0x21, &r);
 }

 Vblank();
 HideMouse();

 WindowBox(6, 6, 38, 9); // across, down, top start, bottom start
 TextOut("Press DELETE to Clear Memory.",brd,fgc,7,7,'s');
 TextOut("It enables cursor box resizing.",brd,fgc,7,8,'s');

 while(!kbhit()){
 }

 LetItGo();

 memcpy(VGA, imprt, SCRN);
 Box(cry, crx);
 ShowMouse();
}
goto GetPress;



DoneBmp:
{
 __dpmi_regs r;

 r.h.ah = 0x0C;
 r.h.al = 0;
 __dpmi_int(0x21,&r);
}

HideMouse();
pcopy(1,0);
ShowMouse();
}



/******************
;Set the palette  *
******************/
void LoadPal()
{
 fseek(bfil, info + 14, SEEK_SET);
 for (a2 = 0; a2 < 256; a2++){		// handle palette first
  b = fgetc(bfil); b=b >> 2;	      // colors are stored as bgr
  g = fgetc(bfil); g=g >> 2;
  r = fgetc(bfil); r=r >> 2;
  fgetc (bfil);			            // spare next byte

  newp[a2<<2]=a2;
  newp[(a2<<2)+1]=r;
  newp[(a2<<2)+2]=g;
  newp[(a2<<2)+3]=b;
 }
}


/********************
;Copy the picture   *
********************/
void CopyPaste(char cp)
{
 word cy, value;

 Vblank();
 HideMouse();
 value = 0;

 if (cp == 1){
  memcpy(VGA, imprt, SCRN);
  for (cy = cry; cy < bmy + MaxY+8; cy++){
	memcpy(&copy[value], &VGA[cy*320+bmx], (bmx + MaxX + 8) - bmx);
	value += (bmx + MaxX + 8) - bmx;
  }
  clr=1;
 }else{
  for (cy = 0; cy < (bmy + MaxY+8)-cry; cy++){
	memcpy(&VGA[(8+cy)*320+144], &copy[value], (bmx + MaxX + 8) - bmx);
	value += (bmx + MaxX + 8) - bmx;
  }
 }/* END IF */
 ShowMouse();
}



/********************
;Reset the palette  *
********************/
void SetPal()
{
  for (a2 = 0; a2 < 256; a2++){
	outportb (0x3C8, newp[a2<<2]);
	outportb (0x3C9, newp[(a2<<2)+1]);
	outportb (0x3C9, newp[(a2<<2)+2]);
	outportb (0x3C9, newp[(a2<<2)+3]);
  }/* Next a2 */
}


/*************************
;Load the BMP Info 	    *
*************************/
void InfoLoad()
{
 fseek(bfil, 14 , SEEK_SET);
 info = getw(bfil);

 fseek(bfil, 0, SEEK_SET);
 ftype = getw(bfil);

 fseek(bfil, 18, SEEK_SET);
 xsz = getw(bfil);

 fseek(bfil, 22, SEEK_SET);
 ysz = getw(bfil);

 fseek(bfil, 10, SEEK_SET);
 fofs = getw(bfil);

 fseek(bfil, 34, SEEK_SET);
 fsize = getw(bfil);

 fseek(bfil, 26, SEEK_SET);
 plns = fgetc(bfil);

 fseek(bfil, 28, SEEK_SET);
 bits = fgetc(bfil);

/* Test for Correct Screen Sizes */
 if (xsz > 320 || ysz > 200){
	Vblank();
	HideMouse();
	pcopy(0,1);
	WindowBox(6, 6, 31, 9); // across, down, top start, bottom start
	TextOut("Only 320x200x256 or less",brd,fgc,7,7,'s');
	TextOut("BMPs. No Compression.",brd,fgc,7,8,'s');
	ShowMouse();

        while(!kbhit()){
	}
         {
         __dpmi_regs r;

         r.h.ah = 0x0C;
         r.h.al = 0;
         __dpmi_int(0x21,&r);
        }

	HideMouse();
	pcopy(1,0);
	ShowMouse();
	clr = 0; stats=0;
 }else{
  stats=1;
 }/* END IF */

/* Test for Bit planes */
 if (bits == 1){
  plen = 8;
 }else if (bits == 4){
  plen = 64;
 }else if (bits == 8){
  plen = 1024;
 }/* END IF */
}/* END SUB */



/*****************************
;Store BMP data to the buffer*
*****************************/
void DrawBmp()
{
 if (bits == 8 || bits == 4){
  LoadPal();
 }

 if (bits == 8){
	a1 = ysz;
	b1 = 0;
	fseek(bfil, fofs, SEEK_SET);
	while(a1 > 0){
	 fread(data, 1, xsz, bfil);
	 memcpy(&imprt[((a1-1)*320)], data, xsz);
	 a1--;
	}/* WEND - a1 */
 }else if(bits == 4){
	a1 = ysz;
	b1 = 0;
	fseek(bfil, fofs, SEEK_SET);
	while(a1 > 0){
	 while(b1 < xsz){
	  c = fgetc(bfil);
	  imprt[((a1-1)*320) + b1] = ((c & 0xF0) >> 4);
	  imprt[((a1-1)*320)+b1+1] = (c & 0x0F);
	  b1+=2;
	 }/* WEND - b1 */
	 a1--;
	 b1=0;
	}/* WEND - a1 */
 }else if(bits == 1){
	a1 = ysz;
	b1 = 0;
	fseek(bfil, fofs, SEEK_SET);
	while(a1 > 0){
	 while(b1 < xsz){
		byte dec=0x80;
		c = fgetc(bfil);
	  for (b2 = 0; b2 < 8; b2++){
		imprt[((a1-1)*320) + (b1+b2)] = ((c & dec) / dec) * 15;
		dec = dec >> 1;
	  }
	  b1+=8;
	 }/* WEND - b1 */
	 a1--;
	 b1=0;
	}/* WEND - a1 */
 }/* END IF */
 fclose(bfil);           //Close it so I don't have to worry about it
}/* RETURN */



/*******************************
;Open the BMP File for loading *
*******************************/
void BMPOpen()
{
 if ((bfil = fopen(NOFile,"r+b")) == NULL){
	Vblank();
	HideMouse();
	pcopy(0,1);
	WindowBox(6, 6, 26, 8); // across, down, top start, bottom start
	TextOut("File Not Found...",brd,fgc,7,7,'s');
	strcpy(NOFile,"");
	ShowMouse();
 }else{
	Vblank();
	HideMouse();
	pcopy(0,1);
	WindowBox(6, 6, 26, 8); // across, down, top start, bottom start
	TextOut("BMP File Loaded..",brd,fgc,7,7,'s');
	ShowMouse();
 }/* END IF */

 while(!kbhit()){
 }
  {
   __dpmi_regs r;
   r.h.al = 0;
   r.h.ah = 0x0C;
   __dpmi_int(0x21, &r);
  }

 HideMouse();
 pcopy(1,0);
 ShowMouse();
}



/*************************
;Let it go, damn it!     *
*************************/
void LetItGo()
{

LetGo:
 if ((inportb(0x60) & 0x80) == 0){
  goto LetGo;
 }

{
 __dpmi_regs r;
  r.h.ah = 0x0C;
  r.h.al = 0;
  __dpmi_int(0x21, &r);
}
}


/*****************
;Screen Mode     *
*****************/
void Screen(byte mode)
{
  __dpmi_regs r;

  r.h.ah = 0;
  r.h.al = mode;
  __dpmi_int(0x10,&r);

}


/*******************
;Wait for Vbalnk   *
*******************/
void Vblank()
{

Vrt:
 vprt = inportw(0x3DA);
 if ((vprt & 8) !=0){
  goto Vrt;
 }else{
  goto NoVrt;
 }/* END IF */

NoVrt:
 vprt = inportw(0x3DA);
 if ((vprt & 8) == 0){
   goto NoVrt;
 }/* END IF */
}



/*****************
;No cursor       *
*****************/
void NoCursor()
{
  __dpmi_regs r;

  r.h.ah = 1;
  r.h.ch = -1;
  r.h.cl = -1;
  __dpmi_int(0x10, &r);

}/* END SUB */



/*****************
;Set Screen mode *
*****************/
void SetMemPoint(int flag)
{
 if (flag == 1){
  __djgpp_nearptr_enable();
  VGA = (byte *)(0xA0000 + __djgpp_conventional_base);
 }else{
    __djgpp_nearptr_disable();
 }/* END IF */
}
