/*
	Extension include file for TileMod
	(c) 2000 Jay
*/
#ifndef __ext_tilemod_h
#define __ext_tilemod_h

#define NULL 0

// the export structure requried by TileMod
typedef struct __external_EXPORTSTRUC
{
	void (*Entry)(); 
	void (*Update)();
	void (*GetEdit)(int ,int ,unsigned char *);
	void (*SetEdit)(unsigned char *);

	int  (*GetWidth)();
	int  (*GetHeight)();
	int  (*GetColumns)();
	int  (*GetRows)();

	int  (*GetCharSize)();
	int  (*GetRowSize)();
	int  (*GetPageSize)();

	void (*SetWidth)(int);
	void (*SetHeight)(int);
	void (*SetColumns)(int);
	void (*SetRows)(int);

	int  BitsPerPixel;
	int  MaxPaletteIndex;
	const char *modestring;
	const char **help;

	int  (*GetEditWidth)();
	int  (*GetEditHeight)();

	unsigned char key1;
	unsigned char key2;
	unsigned char key3;
	unsigned char key4;
	void (*KeyHandler1)();
	void (*KeyHandler2)();
	void (*KeyHandler3)();
	void (*KeyHandler4)();
} EXPORTSTRUC;

typedef struct
{
	// global imports
	unsigned char *rom;      // pointer to the rom
	unsigned char *video;    // pointer to video
	unsigned char *scratch;  // pointer to scratch memory
	int *offset;             // pointer to offset of current display
	const char *help;        // pointer to default help page
	long reserved[4];        // reserved for future use

	// Lib functions
	void * (*AllocMemory)(unsigned size); // allocates some memory
	void * (*ReAllocMemory)(void *ptr,unsigned size); // reallocate memory
	void   (*FreeMemory)(void *ptr);         // frees it

	void * (*MemoryCopy)(void *dest,const void *src,unsigned int len);
	void * (*MemoryFill)(void *src,int c,unsigned int len);

	char * (*StringCopy)(char *dest,const char *src);
	int    (*StringCompare)(const char *a,const char *b);

	int 	 (*sprintf)(char *buf,const char *format,...);

	void (*WriteString)(const char *text,int x,int y);
	void (*WriteStringF)(const char *format,int x,int y,...);

	void (*Pixel)(int x,int y);   // places a pixel on the screen
	void (*Line)(int x1,int y1,int x2,int y2); // draws a line
	void (*Rect)(int x,int y,int width,int height); // draws a rectangle
	void (*FillRect)(int x,int y,int width,int height); // draws a filled rect

	void (*SetColor)(int R,int G,int B);
} IMPORTSTRUC;

#define __rom import.rom
#define __video import.video
#define __scratch import.scratch
#define __offset (*import.offset)
#define __help import.help

#define AllocMemory import.AllocMemory
#define ReAllocMemory import.ReAllocMemory
#define FreeMemory import.FreeMemory

#define MemoryCopy import.MemoryCopy
#define MemoryFill import.MemoryFill

#define StringCopy import.StringCopy
#define StringCompare import.StringCompare

#define sprintf import.sprintf

#define WriteString import.WriteString
#define WriteStringF import.WriteStringF

#define Pixel import.Pixel
#define Line import.Line
#define Rect import.Rect
#define FillRect import.FillRect

#define SetColor import.SetColor

static const IMPORTSTRUC import = {0};

#endif