/*
	ext16x16.c
	16x?? Extension Module for TileMod
*/
#include "ext.h" // include ext.h

static void Init();
static void Update();
static void GetEdit(int x,int y,unsigned char *buf);
static void SetEdit(unsigned char *buf);
static int GetWidth();
static int GetHeight();
static int GetColumns();
static int GetRows();
static int GetCharSize();
static int GetRowSize();
static int GetPageSize();
static void SetWidth(int w);
static void SetHeight(int h);
static void SetColumns(int c);
static void SetRows(int r);
static int GetEditWidth();
static int GetEditHeight();

const char *HelpList[] =
{
	NULL,
	"TMod 16x?? Editor Extension!\n"
	"(c) 2000 Jay",
	NULL
};

// all variables must be static
// define the export struc `export'
static EXPORTSTRUC export =
{
/*Entry*/		Init,
/*Update*/		Update,
/*GetEdit*/ 	GetEdit,
/*SetEdit*/ 	SetEdit,
/*GetWidth*/   GetWidth,
/*GetHeight*/	GetHeight,
/*GetColumns*/ GetColumns,
/*GetRows*/		GetRows,
/*GetCharSize*/GetCharSize,
/*GetRowSize*/ GetRowSize,
/*GetPageSize*/GetPageSize,
/*SetWidth*/	SetWidth,
/*SetHeight*/	SetHeight,
/*SetColumns*/	SetColumns,
/*SetRows*/		SetRows,
/*BPP*/			1,
/*MaxPalIndex*/1,
/*modestring*/	"16x?? Mode",
/*help*/			HelpList,
/*GetEditWid*/ GetEditWidth,
/*GetEditHgt*/	GetEditHeight,
/*key1*/       0,
/*key2*/       0,
/*key3*/       0,
/*key4*/       0,
/*keyhandler1*/NULL,
/*keyhandler2*/NULL,
/*keyhandler3*/NULL,
/*keyhandler4*/NULL
};

static int height = 8, row = 5, col = 8, selx = -1, sely = -1;
static int lastoff = 0;

/*
	Initialization routines
*/
static void Init()
{
	HelpList[0] = __help;
	row = 160 / height;
}

/*
	The draw 16xXX routine
*/
static void Draw16xXX(int x,int y,unsigned char *data,unsigned char *video)
{
	asm ("
		movl %1, %%eax;
		movl %1, %%edx;
		shll $8, %%eax;
		shll $6, %%edx;
		addl %%edx, %%eax;
		addl %0, %%eax;
		addl %%eax, %%edi;
0:
		movw (%%esi), %%ax;
		xchgb %%al, %%ah;

		shlw $1, %%ax;
		setcb (%%edi);
		shlw $1, %%ax;
		setcb 1(%%edi);
		shlw $1, %%ax;
		setcb 2(%%edi);
		shlw $1, %%ax;
		setcb 3(%%edi);
		shlw $1, %%ax;
		setcb 4(%%edi);
		shlw $1, %%ax;
		setcb 5(%%edi);
		shlw $1, %%ax;
		setcb 6(%%edi);
		shlw $1, %%ax;
		setcb 7(%%edi);
		shlw $1, %%ax;
		setcb 8(%%edi);
		shlw $1, %%ax;
		setcb 9(%%edi);
		shlw $1, %%ax;
		setcb 10(%%edi);
		shlw $1, %%ax;
		setcb 11(%%edi);
		shlw $1, %%ax;
		setcb 12(%%edi);
		shlw $1, %%ax;
		setcb 13(%%edi);
		shlw $1, %%ax;
		setcb 14(%%edi);
		shlw $1, %%ax;
		setcb 15(%%edi);

		addl $2, %%esi;
		addl $320, %%edi;

		decl %%ecx;
		jnz 0b;"

		: : "g" (x), "g" (y), "c"(height), "S" (data), "D" (video)
		: "%eax","%ecx","%edx","%edi","%esi"
	);
}

/*
	Update routine
	Updates the screen with data
*/
static void Update()
{
	register int x, y, rindex;

	rindex = __offset;
	for(y = 0; y < row*height; y += height) {
		for(x = 0; x < (col << 4); x += 16) {
			Draw16xXX(x,y,__rom + rindex,__video);
			rindex += (height << 1);
		}
	}

	if(lastoff != __offset) selx = sely = -1;
	lastoff = __offset;
	if((selx | sely) >= 0) {
		SetColor(255,255,255);
		Rect((selx << 4) - 1, (sely * height) - 1,18,height + 2);
	}
}

/*
	Called when the user clicks in the canvas range
*/
static void GetEdit(int x,int y,unsigned char *buf)
{
	int i, j, selpos;

	selx = x >> 4;
	sely = (y / height);

	selpos = (sely * col + selx) * GetCharSize() + __offset;
	if(selx < col && sely < row) {
		MemoryFill(__scratch,0,64000);
		Draw16xXX(0,0,__rom + selpos,__scratch);
		for(i = 0; i < height; i++) {
			for(j = 0; j < 16; j++) {
				buf[(i << 4) + j] = __scratch[(i << 8) + (i << 6) + j];
			}
		}
	} else {
		selx = sely = -1;
	}
}

/*
	When the user clicks edit
*/
static void SetEdit(unsigned char *buf)
{
	int i, j, selpos;
	unsigned short c;

	if((selx | sely) >= 0) {
		selpos = (sely * col + selx) * GetCharSize() + __offset;
		for(i = 0; i < height; i++) {
			for(j = 0, c = 0; j < 16; j++) {
				c <<= 1;
				c |= buf[(i << 4) + j];
			}
			__rom[selpos + (i << 1)] = (unsigned char)(c >> 8);
			__rom[selpos + (i << 1) + 1] = (unsigned char)c;
		}
	}
}

// returns the width
static int GetWidth() { return 16; }
// returns the height
static int GetHeight() { return height; }
// returns the columns
static int GetColumns() { return col; }
// returns the rows
static int GetRows() { return row; }
// returns the size of one tile
static int GetCharSize() { return 2*height; }
// returns the size of one row
static int GetRowSize() { return 2*16*height; }
// returna a page size
static int GetPageSize() { return 2*16*height*row; }
// sets the width
static void SetWidth(int w) {}
// sets the tile height
static void SetHeight(int h)
{
	if(h < 1) height = 1;
	else if(h > 16) height = 16;
	else height = h;

	row = 160 / height;
}

// set columns
static void SetColumns(int c)
{
	if(c < 1) col = 1;
	else if(c > 8) col = 8;
	else col = c;
}

// set the rows
static void SetRows(int r)
{
	row = r;
}

// set edit canvas width
static int GetEditWidth() { return 16; }
// set edit canvas height
static int GetEditHeight() { return height; }
