/*
	template.c
	Extension Template for TileMod
*/
#include "ext.h" // include ext.h

static void Init();
static void Update();
static void GetEdit(int x,int y,unsigned char *buf);
static void SetEdit(unsigned char *buf);
static int GetWidth();
static int GetHeight();
static int GetColumns();
static int GetRows();
static int GetCharSize();
static int GetRowSize();
static int GetPageSize();
static void SetWidth(int w);
static void SetHeight(int h);
static void SetColumns(int c);
static void SetRows(int r);
static int GetEditWidth();
static int GetEditHeight();

const char *HelpList[] =
{
	"(c) 2000 Your name here",
	NULL
};

// define the export struc `export'to list export functions
static EXPORTSTRUC export =
{
/*Entry*/		Init,
/*Update*/		Update,
/*GetEdit*/ 	GetEdit,
/*SetEdit*/ 	SetEdit,
/*GetWidth*/   GetWidth,
/*GetHeight*/	GetHeight,
/*GetColumns*/ GetColumns,
/*GetRows*/		GetRows,
/*GetCharSize*/GetCharSize,
/*GetRowSize*/ GetRowSize,
/*GetPageSize*/GetPageSize,
/*SetWidth*/	SetWidth,
/*SetHeight*/	SetHeight,
/*SetColumns*/	SetColumns,
/*SetRows*/		SetRows,
/*BPP*/			1,
/*MaxPalIndex*/1,
/*modestring*/	"You're mode name here",
/*help*/			HelpList,
/*GetEditWid*/ GetEditWidth,
/*GetEditHgt*/	GetEditHeight,
/*key1*/       0,
/*key2*/       0,
/*key3*/       0,
/*key4*/       0,
/*keyhandler1*/NULL, // install key handlers
/*keyhandler2*/NULL,
/*keyhandler3*/NULL,
/*keyhandler4*/NULL
};


/*
	Initialization routines
*/
static void Init()
{
	/* Write startup routines here*/
}

/*
	Update routine
*/
static void Update()
{
	/* Write tile drawing code here */
}

/*
	Called when the user clicks in the canvas range
*/
static void GetEdit(int x,int y,unsigned char *buf)
{
	/* place getedit code he
}

/*
	When the user clicks edit
*/
static void SetEdit(unsigned char *buf)
{

}

// returns the width
static int GetWidth() { return 8; }
// returns the height
static int GetHeight() { return 8; }
// returns the columns
static int GetColumns() { return 16; }
// returns the rows
static int GetRows() { return 20; }
// returns the size of one tile
static int GetCharSize() { return 8*8; }
// returns the size of one row
static int GetRowSize() { return 8*8*16; }
// returna a page size
static int GetPageSize() { return 8*8*16*20; }
// sets the width
static void SetWidth(int w) {}
// sets the tile height
static void SetHeight(int h)
{
}

// set columns
static void SetColumns(int c)
{
}

// set the rows
static void SetRows(int r)
{
}

// set edit canvas width
static int GetEditWidth() { return 8; }
// set edit canvas height
static int GetEditHeight() { return 8; }
